#ifndef _DEFINE_H_
#define _DEFINE_H_

#include <stdint.h>

#define   __RO  volatile const       
#define   __WO  volatile             
#define   __RW  volatile  

#define Sint8   int8_t
#define Sint16  int16_t
#define Sint32  int32_t
#define Uint8   uint8_t
#define Uint16  uint16_t
#define Uint32  uint32_t

#define Sint8_  volatile int8_t
#define Sint16_ volatile int16_t
#define Sint32_ volatile int32_t
#define Uint8_  volatile uint8_t
#define Uint16_ volatile uint16_t
#define Uint32_ volatile uint32_t

#define REG8    volatile Uint8
#define REG16   volatile Uint16
#define REG32   volatile Uint32

#define HW8_REG(ADDRESS)   (*((REG8  *)(ADDRESS)))
#define HW16_REG(ADDRESS)  (*((REG16 *)(ADDRESS)))
#define HW32_REG(ADDRESS)  (*((REG32 *)(ADDRESS)))

#define BIT31   (1<<31)
#define BIT30   (1<<30)
#define BIT29   (1<<29)
#define BIT28   (1<<28)
#define BIT27   (1<<27)
#define BIT26   (1<<26)
#define BIT25   (1<<25)
#define BIT24   (1<<24)

#define BIT23   (1<<23)
#define BIT22   (1<<22)
#define BIT21   (1<<21)
#define BIT20   (1<<20)
#define BIT19   (1<<19)
#define BIT18   (1<<18)
#define BIT17   (1<<17)
#define BIT16   (1<<16)

#define BIT15   (1<<15)
#define BIT14   (1<<14)
#define BIT13   (1<<13)
#define BIT12   (1<<12)
#define BIT11   (1<<11)
#define BIT10   (1<<10)
#define BIT9    (1<<9)
#define BIT8    (1<<8)

#define BIT7    (1<<7)
#define BIT6    (1<<6)
#define BIT5    (1<<5)
#define BIT4    (1<<4)
#define BIT3    (1<<3)
#define BIT2    (1<<2)
#define BIT1    (1<<1)
#define BIT0    (1<<0)

#define PASS    (0)
#define FAIL    (1)

#define DISABLE	(0)	
#define ENABLE	(1)

#define OFF			(0)	
#define ON			(1)

#define MASTER  (BIT0)
#define SLAVE   (BIT1)

#define BIT(n)  (1<<n)  //ex: BIT(1).....

#define DIRECT  ( 0 )
#define FIFO    ( 1 )

#endif
